%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   Field computation in plate and cube problems


clear all; 
close all;
N = 100;  %total number of patches
a = 1;
V0 = 1;
EPS0 = 8.8542*10^(-12);
n = sqrt(N);

%coordinates of centers of patches

[x,y,S] = localCoordinates(n,n,a,a);

%matrix A 

A = matrixA(EPS0,S,x,y);

%matrix B

B = V0*ones(1,N)';  %transpose 

rhos = A\B;  %solving the equation

%field
d = [a/2,2*a,100*a];

 fprintf('\nField values:');
for i=1:length(d)
    [E,unitE,Emag] = fieldE(EPS0,a/2,a/2,d(i),rhos,S,x,y);
    fprintf('\n %f [%.2f %.2f %.2f] V/m',Emag,unitE);
end;

%%
clear all; 
close all;
N = 600;
Nside = N/6;
a = 1;
V0 = 1;
EPS0 = 8.8542*10^(-12);
n = sqrt(Nside);

[p,q,dS] = localCoordinates(n,n,a,a);
temp0 = zeros(1,Nside);
temp1 = a*ones (1,Nside);


x = [p,p,p,p,temp0,temp1];
y = [q,q,temp0,temp1,p,p];
z = [temp0,temp1,q,q,q,q];
S = [dS,dS,dS,dS,dS,dS];


%matrix A 
A = matrixA(EPS0,S,x,y,z);

%matrix B

B = V0 * ones(N,1);  %transpose 

rhos = A\B;  %solving the equation

d = [a/4,a/2];

%field
fprintf('\nField values:');
for i=1:length(d)
    [E,unitE,Emag] = fieldE(EPS0,d(i),d(i),d(i),rhos,S,x,y,z);
     fprintf('\n %f [%.2f %.2f %.2f] V/m',Emag,unitE);
end;
